const bool shadowcolor0Mipmap = true;

varying vec2 texcoord;

const float OFFSETS[6] = float[6](
    -4.378621204796657,
    -2.431625915613778,
    -0.4862426846689485,
    1.4588111840004858,
    3.4048471718931532,
    5);

const float WEIGHTS[6] = float[6](
    0.09461172151436463,
    0.20023097066826712,
    0.2760751120037518,
    0.24804559825032563,
    0.14521459357563646,
    0.035822003987654526);

void main()
{
    /* RENDERTARGETS: 11 */
    float noise = R2_dither(gl_FragCoord.xy) * 0.75;

    vec3 color = vec3(0.0); // Center sample
    vec2 size = textureSize(shadowcolor0, 0);

    float mip = int(floor(log2(float(shadowMapResolution))));

    // Apply Gaussian blur by sampling in a 2D kernel
    for (int i = 1; i < 6; ++i)
    {
        float offset = OFFSETS[i] * 32.0;
        color += texture(shadowcolor0, texcoord + vec2(offset, noise) / size, mip).rgb * WEIGHTS[i];
        color += texture(shadowcolor0, texcoord + vec2(noise, offset) / size, mip).rgb * WEIGHTS[i];
    }

    gl_FragData[0].rgb = color;
    gl_FragData[0].a = 1;
}
